#ifndef __ANAGRAMS_H__
#define __ANAGRAMS_H__
/*------------------------------------------------------------------------
  **** BEGIN LICENSE BLOCK ****
  Version: MPL 1.1/GPL 2.0/LGPL 2.1
  Copyright(c) 2004-2010 Created by Eric Fredericksen (www.pttpsystems.com)
  All Rights Reserved.

  This program are subject to the Mozilla Public License Version
  1.1 (the "License"); you may not use this file except in compliance with
  the License. You may obtain a copy of the License at
  http://www.mozilla.org/MPL/

  This program is free software. Software distributed under the License
  is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
  either express or implied. See the License for the specific language
  governing rights and limitations under the License.

  Alternatively, the contents of this file may be used under the terms of
  either the GNU General Public License Version 2 or later (the "GPL"), or
  the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
  in which case the provisions of the GPL or the LGPL are applicable instead
  of those above. If you wish to allow use of your version of this file only
  under the terms of either the GPL or the LGPL, and not to allow others to
  use your version of this file under the terms of the MPL, indicate your
  decision by deleting the provisions above and replace them with the notice
  and other provisions required by the GPL or the LGPL. If you do not delete
  the provisions above, a recipient may use your version of this file under
  the terms of any one of the MPL, the GPL or the LGPL.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 Temple
  Place, Suite 330, Boston, MA 02111-1307 USA
  **** END LICENSE BLOCK ****
------------------------------------------------------------------------*/


#include <map>
#include <string>
#include <vector>

using namespace std;


//==================================================
//
//==================================================
class CAnagramSignature
{
public:
	// this can be changed in size if 255 instances of a single character are not enough
	typedef unsigned char counter_type;
	// assume that case counts.  This covers both cases but costs twice the space.
	enum
	{
		CHARACTER_COUNT = 26*2,
		DWORD_COUNT = (CHARACTER_COUNT*sizeof(counter_type) + sizeof(DWORD) - 1)/sizeof(DWORD)
	};


protected:

	// for map operator
	friend bool operator<( const CAnagramSignature & _roLeft, const CAnagramSignature & _roRight);

	union
	{
		// anonymous union may not be portable
		counter_type	m_factSignature[CHARACTER_COUNT];
		DWORD			m_fadwSignature[DWORD_COUNT];

	} m_oData;

public:

	CAnagramSignature(LPCTSTR _ptcString = NULL);

	void Signify(LPCTSTR _ptcString);

};


//==================================================
// must define this for using CAnagramSignature as a map<> key
//==================================================
bool operator<( const CAnagramSignature & _roLeft, const CAnagramSignature & _roRight);

//==================================================
//
//==================================================
class CAnagramDictionary
{
public:

	enum
	{
		MAX_STRING_LENGTH = 1024,
		MAX_LINEREAD_BUFFER = MAX_STRING_LENGTH+1
	};

protected:

	// for protecting access to map
	CRITICAL_SECTION m_oCriticalSection;
	// for storing our precomputed responses looked up by unique signature
	map<CAnagramSignature, string> m_oSignatureMap;

	float m_fLoadTime;

public:

	CAnagramDictionary(LPCTSTR _ptcFileName=NULL);
	virtual ~CAnagramDictionary();

	bool LoadWordList(LPCTSTR _ptcFileName);

	string ThreadSafeLookup(const CAnagramSignature & _roSignature);

	float LoadTime(void) { return(	m_fLoadTime ); }
};

//==================================================
//
//==================================================
class CWordList
{
public:
	enum
	{
		MAX_STRING_LENGTH = 1024,
		MAX_LINEREAD_BUFFER = MAX_STRING_LENGTH+1
	};

protected:
	// for protecting access to word list
	CRITICAL_SECTION m_oCriticalSection;
	// for storing our strings
	vector<string> m_oWordList;

	float m_fLoadTime;

public:
	CWordList(LPCTSTR _ptcFileName=NULL);
	virtual ~CWordList();
	bool m_bWordListLoaded;
	bool LoadWordList(LPCTSTR _ptcFileName);
	string ThreadSafeLookup(DWORD _dwIndex);

	float LoadTime(void) { return(	m_fLoadTime ); }

};



#endif // __ANAGRAMS_H__
